/*------------------------------------------*/
/*     program name: TPC.C  version 2.0     */
/*------------------------------------------*/

extern int in32k(int *,int,int);
extern int out32kx(int *,int,int,int);
/* out32k(&buffer,read_length,port_adr,com_mode)
com_mode=0 is old mode(use SLCT_IN,AUTO.FX)
com_mode=1 is new mode(use ERROR,SLCT)
return code=0 is ok, other code is error */
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <dir.h>

char com_mode;
unsigned int port[4],port_adr,port_adr1,port_adr2;
int max_port,sel_port,no,number_of_32k,action_flag;
char file_name[128],error_code,adj_name[12],flag,ext_cmd;
char file_no[12][128];
char org_file[MAXFILE];
char drive[MAXDRIVE],dir[MAXDIR],file[MAXFILE],ext[MAXEXT];
FILE *fptr;
long file_len;
unsigned char buffer[32768];
#define error 8
#define busy 0x80
#define stb_hi 0x04
#define stb_lo 0x05
#define space 0x20
#define trans_size 32768
#define loop_cnt 8192
struct ffblk fblock;
div_t x;

/*************************************************
*                  MAIN ENTRY                    *
*************************************************/
void main(argc,argv)
int argc;
char **argv;
{
get_port();
   printf("---------- PC to V64 upload/download program version 2.0 ----------\n");

if (max_port==0)
   {
   printf("no printer port can be use !!!\n");
   exit(-1);
   }
if (argc>2)
   ext_cmd=1;
else
   ext_cmd=0;
if (ext_cmd)
   /* argv[0]->'tpc.exe		   argc=1
   argv[1]->port                   argc=2
   argv[2]->file1                  argc=3
   argv[3]->file2...*/
   {
   sel_port=atoi(argv[1]);
   port_ext();
   }
else
   port_select();	/* no fellow parameter */
   /* prompt to select what is the port will be use */

init_port();
/************** main command entry loop ***************/
if (ext_cmd)
   {
   strcpy(file_name,argv[2]);
   strupr(file_name);
/* printf("Download file : %s\n",file_name);*/
   if (file_name[0]=='/')
      open_recive();
   else
      open_transfer();
   }
else
   {
   while (1)
      {
	  printf("\n");
      if (com_mode==1)
	     printf("*");
      printf("Command [out(file)] [in(/file)] [quit] : ");
      scanf("%s",file_name);
      strupr(file_name);

      if (!strcmp("Q",file_name) || !strcmp("QUIT",file_name))
	 exit(0);
      else
	 {
	 if (file_name[0]=='/')
	    open_recive();
	 else
	    open_transfer();
	 }
      }
   }
}

/**************************************
*               Subroutine            *
**************************************/

open_recive(void)
{
unsigned char *ch[2],total_file;
unsigned int read_length;
int i,j,result_in_32k;
for (i=0;i<strlen(file_name);i++)
   file_name[i]=file_name[i+1];		/* delete the first char '/' */
if (strlen(file_name)==0) return(-1);
flag=fnsplit(file_name,drive,dir,file,ext);
/*printf("recive data request");*/
while (sync_header())
   {
   if (kbhit())
      if (getch()==0x1b)
	 exit(-1);
   flip_action();
   }
if (send_read_header()!=0)         /* send 'GD6W' and total file no */
   {
   printf("Header com. error!\07\n");
   return(-1);
   }
if (out_file_name()!=0)
   {
   printf("File name com. error!\07\n");
   return(-1);
   }
if (check_sync()!=0)		/* sync busy & D7 */
   {
   printf("Sync busy error!\07\n");
   return(-1);
   }
if (in32k(&buffer,1,port_adr)!=0)
   {
   printf("communication error !!!\07\n");
   return(-1);
   }
total_file=buffer[0];		/* get total file number */
printf("total file=%d\n",total_file);
if (total_file>0)
   {
   while (total_file>0)
      {
      if (in32k(&buffer,15,port_adr)!=0)
	 {
	 printf("recive 15 bytes communication error !!!\07\n");
	 return(-1);
	 }
      strcpy(file,"");
      strcpy(ext,"");
      file_len=(buffer[0]+buffer[1]*0x100)&0xffff;
      file_len=(file_len+buffer[2]*0x10000)&0xffffff;
      file_len=(file_len+buffer[3]*0x1000000)&0xffffffff;
      for (i=4;i<12;i++)
	 {
	 *ch=buffer[i];
	 if (*ch!=' ') strcat(file,ch);
	 }
      for (i=12;i<15;i++)
	 {
	 *ch=buffer[i];
	 if (*ch!=' ') strcat(ext,ch);
	 }
/* create file and recive data*/
      fnmerge(file_name,drive,dir,file,ext);
/*      printf("file length=%lx\n",file_len);*/
      printf("%s <= recive ",file_name);
      if((fptr=fopen(file_name,"w+b"))==NULL)
	 {/* open error */
	 printf("open error !!!\07\n");
	 return(-1);
	 }
      else
	 {
	 if (write_file()!=0)
	    {
	    printf("write error !!!\07\n");
	    return(-1);
	    }
	 }
      total_file--;	/* total_file=total_file-1 */
      }
   return(0);
   }
else
   {
   printf("no data recive\n");
   return(-1);
   }
}

int write_file(void)
{
int len;
while (file_len)
   {
   if (file_len>=trans_size)
      {
      if (in32k(&buffer,trans_size,port_adr)!=0)
	 {
	 fclose(fptr);				/* recive data error */
	 return(-1);
	 }
      else
	 {
	 if (fwrite((char *)buffer,sizeof(char),trans_size,fptr)!=trans_size)
	    {
	    fclose(fptr);	/* write data error */
	    return(-1);
	    }
	 }
      file_len=file_len-trans_size;		/* sub 0x8000h file length */
      printf(".");
      }
   else
      {
      len=file_len;			/* long int-> short int */
      if (in32k(&buffer,len,port_adr)!=0)
	 {
	 fclose(fptr);				/* recive data error */
	 return(-1);
	 }
      else
	 {
	 if (fwrite((char *)buffer,sizeof(char),len,fptr)!=len)
	    {
	    fclose(fptr);	/* write data error */
	    return(-1);
	    }
	 }
      file_len=0;		/* finish */
      printf(".");
      }
   }
printf("\n");
fclose(fptr);
return(0);
}

int in_data(void)
{
return (in32k(&buffer,1,port_adr));
}

port_select(void)
{
sel_port=1;			/* set default to port 1 */
if (max_port > 1)
   {
   printf("Please input download printer port no (1-%d) : ",max_port);
   sel_port=getch();
   if(sel_port!='\r')   /* press 'Enter' */
      {
      if(sel_port<'1' || sel_port>(max_port+'0'))
	 {
	 printf("no this port, error!!!\07\n");
	 exit(-1);
	 }
      sel_port=sel_port-'0';
      printf("%x\n",sel_port);
      }
   else
      {
      printf("1\n");
      sel_port=1;
      }
   }
/*
printf("commucation port is %04x\n",port_adr);
*/
}

port_ext(void)
{
printf("port select is : ");
if (max_port > 1)
   {
   if(sel_port<1 || sel_port>(max_port))
      {
      printf("no this port, error!!!\07\n");
      exit(-1);
      }
   printf("%x\n",sel_port);
   }
else
   {
   sel_port=1;
   printf("1\n");
   }
}

init_port(void)
{
port_adr=port[sel_port];
port_adr1=port_adr+1;
port_adr2=port_adr+2;
outportb(port_adr2,stb_hi);		/* init port */
}

int sync_header_old(void)	/* old mode use(slct_in,auto.fx) */
{
int i;
i=0;

while (i<loop_cnt)
   {
   if ((inportb(port_adr2)&8)==0) /* inverse slct_in = 1 */
      {
      outportb(port_adr,0xaa);
      outportb(port_adr2,0);			/* set init-> ~~~~~~|_______ */
      while (i<loop_cnt)
	 {
	 if (inportb(port_adr2)&8)    	/* inverse slct_in = 0 */
	    {
	    outportb(port_adr2,4);		/* set init->  ______|~~~~~~~ */
	    while (i<loop_cnt)
	       {
	       if ((inportb(port_adr2)&8)==0) /* inverse slct_in = 1 */
		  {
		  outportb(port_adr,0x55);	/* old mode use(slct_in,auto.fx) */
		  outportb(port_adr2,0);  	/* set init-> ~~~~~~|_______ */
		  while (i<loop_cnt)
		     {
		     if (inportb(port_adr2)&8)  /* inverse slct_in = 0 */
			{
			outportb(port_adr2,4);  /* set init->  ______|~~~~~~~ */
			while (i<loop_cnt)
			   {
			   if ((inportb(port_adr2)&8)==0)     /* inverse slct_in = 1 */
			      return(0);			/* sync ok */
			   i++;
			   }
			}
		     i++;
		     }
		  }
	       i++;
	       }
	    }
	 i++;
	 }
      }
   i++;
   }
outportb(port_adr2,4);
outportb(port_adr,0);
com_mode=1;		/* use new com mode */
return(-1);
}

int sync_header_new(void)	/* new mode use(error,slct) */
{
int i;
i=0;

while (i<loop_cnt)
   {
   if (inportb(port_adr1)&8) 		/* error = 1 */
      {
      outportb(port_adr,0xa5);
      outportb(port_adr2,0);		/* set init-> ~~~~~~|_______ */
      while (i<loop_cnt)
	 {
	 if (!(inportb(port_adr1)&8))  	/* error = 0 */
	    {
	    outportb(port_adr2,4);		/* set init->  ______|~~~~~~~ */
	    while (i<loop_cnt)
	       {
	       if (inportb(port_adr1)&8) /* error = 1 */
		  {
		  outportb(port_adr,0x5a);	/* old mode use(slct_in,auto.fx) */
		  outportb(port_adr2,0);  	/* set init-> ~~~~~~|_______ */
		  while (i<loop_cnt)
		     {
		     if (!(inportb(port_adr1)&8))  /* error = 0 */
			{
			outportb(port_adr2,4);  /* set init->  ______|~~~~~~~ */
			while (i<loop_cnt)
			   {
			   if (inportb(port_adr1)&8)     /* error = 1 */
			      return(0);		 /* sync ok */
			   i++;
			   }
			}
		     i++;
		     }
		  }
	       i++;
	       }
	    }
	 i++;
	 }
      }
   i++;
   }
outportb(port_adr2,4);
outportb(port_adr,0);
com_mode=0;		/* use new com mode */
return(-1);
}

int sync_header(void)
{
/* port_adr2:d0->stb, d1->auto.fx, d2->init, d3->slct_in */
/* port_adr1:d7->busy, d6->ack, d5->pe, d4->slct, d3->error */
   outportb(port_adr2,4);                  /* set stb,auto,init,slct=high */
   if (com_mode)
      return(sync_header_new());	/* new mode use(error,slct) */
   else
      return(sync_header_old());	/* old mode use(slct_in,auto.fx) */
}



get_port(void)
{
int i;
port[1]=mem_value(8);
port[2]=mem_value(10);
port[3]=mem_value(12);
port[4]=mem_value(14);
max_port=0;		/* init max. port is 0 */
for (i=1;i<5;i++)
   {
   if (port[i]==0) break;
   max_port=i;
   printf("port%d = %x\n",i,port[i]);
   if (i<4)
      if (port[i]==port[i+1]) break;
   }
printf("\n");
}

mem_value(offset)
{
unsigned char far *ptr,ptr_low;
unsigned int ptr_high;
ptr = (char far *)0x400;
ptr_low=*(ptr+offset);
ptr_high=(*(ptr+offset+1))<<8 | ptr_low;
return(ptr_high);
}

open_transfer(void)
{
int i;
//flag=fnsplit(file_name,drive,dir,file,ext);
      transfer();			/* transfer file */
}


transfer(void)
{
unsigned int read_length;
int i,result_out_32k;
number_of_32k=0;		  /* init number of 32k to be tr. */
   if (find_first())		/* file open fail */
      {
      printf("file not found!!!\07\n");
      return(-1);
      }
   while (sync_header())
      {
      if (kbhit())
	 if (getche()==0x1b)
	    exit(-1);
      flip_action();
      }
   if (send_write_header()!=0)     /* send 'GD6R'/'DSF3' and total file no */
      {
      printf("Header com. error!\07\n");
      return(-1);
      }
   printf("%s => ",file_name);	/* print out file name */
   file_len=fblock.ff_fsize;
   flag=fnsplit(file_name,drive,dir,file,ext);
   if((fptr=fopen(file_name,"rb"))!=NULL)
      {
      printf("transfer ");
      if (out_file_len()!=0)
	 {
	 printf("File length com. error!\07\n");
	 return(-1);
	 }
      if (out_file_name()!=0)
	 {
	 printf("File name com. error!\07\n");
	 return(-1);
	 }
      while(file_len)
	 {
	 read_length=fread((char *)buffer,sizeof(char),trans_size,fptr);
	 file_len = file_len - read_length;
	 if (read_length!=0)
	    {
	    if(file_len<0)
	       {
	       printf(" Error !\n");
	       file_len=0; 	/* exit while loop */
	       i=no;
	       break;
	       }
	    number_of_32k++;
	    printf(".");
	       result_out_32k=out32kx(&buffer,read_length,port_adr2,com_mode);
	    if (result_out_32k > 0)		/* out data error */
	       {
	       printf("(%x:%x)",(number_of_32k-1),(read_length-result_out_32k));
	       i=no;
	       break;
	       }
	    /* call assembler out_32k program */
	    }
	 else
	    {
	    file_len=0; 	/* exit while loop */
	    i=no;
	    break;
	    }
	 }
      fclose(fptr);
      printf("\n");
      }
}

int out_file_name(void)
{
int i,skip;
skip=0;
for (i=0;i<8;i++)
   {
   if (file[i]==0) skip=1;		/* set skip flag */
   if (skip)
      {
      if (out_data(space)!=0) return(-1);
      }
   else
      {
      if (out_data(file[i])!=0) return(-1);
      }
   }
skip=0;
if (ext[0]=='.')
   for (i=0;i<3;i++)
      ext[i]=ext[i+1];		/* delete the first char '.' */
for (i=0;i<3;i++)
   {
   if (ext[i]==0) skip=1;		/* set skip flag */
   if (skip)
      {
      if (out_data(space)!=0) return(-1);
      }
   else
      {
      if (out_data(ext[i])!=0) return(-1);
      }
   }
return(0);
}

int out_file_len(void)
{
if (out_data(file_len)!=0) return(-1);		        /* LL */
if (out_data(file_len>>8)!=0) return(-1);	        /* LH */
if (out_data(file_len>>16)!=0) return(-1);	        /* HL */
if (out_data(file_len>>24)!=0) return(-1);	        /* HH */
return(0);
}


int out_data(unsigned char data)
{
buffer[0]=data;
/* out_32k(&buffer,read_length,port_adr) */
   return(out32kx(&buffer,1,port_adr2,com_mode));
}

flip_action(void)
{
int tmp;
action_flag++;
tmp=action_flag;
x=div(tmp,5);
switch (x.rem)
   {
   case 0:printf("|");
	break;
   case 1:printf("/");
	break;
   case 2:printf("-");
	break;
   case 3:printf("|");
	break;
   case 4:printf("\\");
	break;
   }
printf("\x08");			/* backspce */
}


int find_first(void)
{
return(findfirst(file_name,&fblock,FA_RDONLY));
}

int find_next(void)
{
return(findnext(&fblock));
}


int find_open(void)
{
if((fptr=fopen(file_name,"rb"))==NULL)		/* open binary file */
   return(1);
else
   {
   file_len=filelength(fileno(fptr));
   return(0);				/* open success */
   }
}

int send_expand_header()
{
   strcpy(buffer,"GD6E");
   return(out32kx(&buffer,4,port_adr2,com_mode));   /* link header 'GD6E' */
}

int send_write_header()
{
   strcpy(buffer,"GD6R");
   buffer[4]=no;
   return(out32kx(&buffer,5,port_adr2,com_mode));   /* link header 'GD6R' */
}


int send_read_header(void)
{
strcpy(buffer,"GD6W");
return(out32kx(&buffer,4,port_adr2,com_mode));
/* link header 'GD6W' */
}

int check_sync(void)
{
int i,j;
for (i=0;i<loop_cnt;i++)
   {
      if (((inportb(port_adr2)&3)==3 || (inportb(port_adr2)&3)==0) && com_mode==0)
	 {
	 outportb(port_adr,0);	/* set D7=0 */
	 for (j=0;j<loop_cnt;j++)
	    {
	    if ((inportb(port_adr1)&0x80)==0)	// check busy
	       {
/*	    outportb(port_adr,0x80);		/* set D7=0 */
	       return(0);
	       }
	    }
	 return(-1);
	 }
      if (((inportb(port_adr2)&1)^((inportb(port_adr1)&0x10)>>4)) && com_mode==1)	// new mode
	 {
	 outportb(port_adr,0);	/* set D7=0 */
	 for (j=0;j<loop_cnt;j++)
	    {
	    if ((inportb(port_adr1)&0x80)==0)	// check busy
	       {
/*	    outportb(port_adr,0x80);		/* set D7=0 */
	       return(0);
	       }
	    }
	 return(-1);
	 }
   }
return(-1);
}

