;call out32kx(&buffer,read_length,port_adr,com_mode) assembler in turboc
;               bp+4 ,   bp+6    ,  bp+8,bp+10
;com_mode=0 is old mode(use SLCT_IN,AUTO.FX)
;com_mode=1 is new mode(use ERROR,SLCT)
;return code=0 is ok, other code is error and contain a least byte to send!!!



_TEXT segment byte public 'CODE'
	assume cs:_TEXT
	public _out32kx

STB_LO	EQU	05H
STB_HI	EQU	04H
BUSY	EQU	080H
ERROR	EQU	08H
xtimer	equ	20
timer	equ	0
SLCT	equ	10h

_out32kx proc
	push	bp
	mov	bp,sp
	mov	bx,[bp+4]		;buffer pointer
	mov	cx,[bp+6]		;read_length
	mov	dx,[bp+8]		;port_adr2
	mov	ax,[bp+10]		;mode
	push	si
	mov	si,cx			;read length
;port_adr2=port_a(0x37a)
;*********************************************************
;  d             3           2           1           0
;             slct_in       init   auto.fd.xt.     strobe
;*********************************************************
;port_adr1=port_9(0x379)
;*********************************************************
;  d     7        6       5      4         3
;       busy     ack     pe     slct     error
;*********************************************************

	cmp 	ax,0
	jne	new_mode
	in	al,dx
	test	al,1			;check strobe status(D0)
	jnz	out_32k_odd	
out_32k_even:
	mov	ah,xtimer		;how many timer value
	mov	cx,timer		;timer value
out_32k_even_1:
	in	al,dx			;port_adr2
	test	al,2			;check auto.fd.xt status(D1)
	jz	out_32k_even_2
	loop	out_32k_even_1
	dec	ah
	jnz	out_32k_even_1
	jmp	out_32k_err
out_32k_even_2:
	dec	dx
	dec	dx
	mov	al,[bx]
	out	dx,al				;port_adr : data
	inc	dx
	inc	dx
	mov	al,5		;stb=0
	out	dx,al				;port_adr2
	inc	bx
	dec	si
	jz	out_32k_exit
out_32k_odd:
	mov	ah,xtimer		;how many timer value
	mov	cx,timer		;timer value
out_32k_odd_1:
	in	al,dx			;port_adr2
	test	al,2			;check auto.fd.xt status(D1)
	jnz	out_32k_odd_2
	loop	out_32k_odd_1
	dec	ah
	jnz	out_32k_odd_1
	jmp	out_32k_err
out_32k_odd_2:
	dec	dx
	dec	dx
	mov	al,[bx]
	out	dx,al				;port_adr : data
	inc	dx
	inc	dx
	mov	al,4		;stb=1
	out	dx,al				;port_adr2
	inc	bx
	dec	si
	jnz	out_32k_even
out_32k_exit:
	mov	ax,0
	pop	si
	pop	bp
	ret

new_mode:				;port_adr2(0x37a)
	in	al,dx
	test	al,1			;check strobe status(D0)
	jnz	new_out_32k_odd	
new_out_32k_even:
	dec	dx			;point to port_adr1(0x379)
	mov	ah,xtimer		;how many timer value
	mov	cx,timer		;timer value
new_out_32k_even_1:
	in	al,dx			;port_adr1(0x379)
	test	al,10h 			;check SLCT status(D4)
	jnz	new_out_32k_even_2
	loop	new_out_32k_even_1
	dec	ah
	jnz	new_out_32k_even_1
out_32k_err:
	mov	ax,si
	pop	si
	pop	bp
	ret

new_out_32k_even_2:
	dec	dx			;point to port_adr0(0x378)
	mov	al,[bx]
	out	dx,al			;port_adr : data
	inc	dx
	inc	dx
	mov	al,5			;stb=0
	out	dx,al			;port_adr2
	inc	bx
	dec	si
	jz	out_32k_exit
new_out_32k_odd:
	dec	dx			;point to port_adr1(0x379)
	mov	ah,xtimer		;how many timer value
	mov	cx,timer		;timer value
new_out_32k_odd_1:
	in	al,dx			;port_adr1(0x379)
	test	al,10h			;check SLCT status(D4)
	jz	new_out_32k_odd_2
	loop	new_out_32k_odd_1
	dec	ah
	jnz	new_out_32k_odd_1
	jmp	out_32k_err
new_out_32k_odd_2:
	dec	dx			;point to port_adr0(0x378)
	mov	al,[bx]
	out	dx,al			;port_adr : data
	inc	dx
	inc	dx			;point to port_adr2(0x37a)
	mov	al,4			;stb=1
	out	dx,al			;port_adr2
	inc	bx
	dec	si
	jnz	new_out_32k_even
	jmp	out_32k_exit

_out32kx	endp
_TEXT	ends
	end
