;call in32k(&buffer,read_length,port_adr) assembler in turboc
;               bp+4 ,   bp+6    ,  bp+8
;return code=0 is ok, other code is error and contain a least byte to recive!!



_TEXT segment byte public 'CODE'
	assume cs:_TEXT
	public _in32k

busy	equ	080h
xtimer	equ	20
timer	equ	0
high_nibble	equ	080h
low_nibble	equ	0


_in32k proc
	push	bp
	mov	bp,sp
	mov	bx,[bp+4]		;buffer pointer
	mov	cx,[bp+6]		;read_length
	mov	dx,[bp+8]		;port_adr
	push	si
	mov	si,cx
	mov	di,bx
	mov	al,high_nibble          ;set D7=1
	out	dx,al			;port_adr
in32k_0:
	inc	dx			;point to port_adr+1
	mov	bl,xtimer		;how many timer value
	mov	cx,timer		;timer value
in32k_1:
	in	al,dx			;port_adr1
	test	al,busy
	jnz	in32k_low_nibble
	loop	in32k_1
	dec	bl
	jnz	in32k_1
	jmp	in32k_err
in32k_low_nibble:
	in	al,dx			;port_adr1
	shr	al,1
	shr	al,1
	shr	al,1
	and	al,0fh			;mask low nibble
	mov	ah,al			;save low nibble
	dec	dx
	mov	al,low_nibble
	out	dx,al			;port_adr acknowledge low nibble
	inc	dx
in32k_2:
	in	al,dx			;port_adr1
	test	al,busy
	jz	in32k_high_nibble
	loop	in32k_2
	dec	bl
	jnz	in32k_2
	jmp	in32k_err
in32k_high_nibble:
	in	al,dx			;port_adr1
	shl	al,1
	and	al,0f0h
	or	al,ah
	mov	[di],al			;save data to buffer
	dec	dx			;point to port_adr
	mov	al,high_nibble
	out	dx,al			;port_adr acknowledge high nibble
	inc	di
	dec	si
	jnz	in32k_0
	mov	ax,0
	pop	si
	pop	bp
	ret
in32k_err:
	mov	ax,si			;remainder value
	pop	si
	pop	bp
	ret


_in32k	endp
_TEXT	ends
	end
