/* 
  
  IPS v1.0 for UNIX by madman
  
*/

#include <stdio.h>

main (int argc, char* argv[])
{
   FILE *ipsfile, *patchee;
   char patch[5];
   char byte;
   int done=0, check=1, add2, add1, add0, len2, len1, len0;
   unsigned long offset, length, i;
   
   printf("IPS Patcher v1.0 for UNIX by madman\n\n");
   
   if (argc<3) {
      printf ("Usage: %s <patchfile> <file_to_patch>\n", argv[0]);
      exit(0);
   }
   
   ipsfile=fopen(argv[1], "r");
   if (ipsfile==NULL) {
      printf("Could not open the file %s\n", argv[1]);
      exit(0);
   }
   
   patchee=fopen(argv[2], "r+");
   if (patchee==NULL) {
      printf("Could not open the file %s\n", argv[2]);
      exit(0);
   }
   
   fgets(patch, 6, ipsfile);
   if (strcmp(patch, "PATCH")!=0) { //make sure its a valid IPS
      printf("Invalid IPS File!\n");
      exit(0);
   }
   
   printf("Applying IPS Patch...\n");
   while (done==0) {
      fread(&byte, 1, 1, ipsfile);
      if ((add2=byte)<0) add2+=256;
      fread(&byte, 1, 1, ipsfile);
      if ((add1=byte)<0) add1+=256;
      fread(&byte, 1, 1, ipsfile);
      if ((add0=byte)<0) add0+=256;
      offset=((add2*256*256)+(add1*256)+add0);
      if (offset==4542278) {
	 done=1;
	 break;
      }
      fseek(patchee, offset, SEEK_SET);
      fread(&byte, 1, 1, ipsfile);
      if ((len1=byte)<0) len1+=256;
      fread(&byte, 1, 1, ipsfile);
      if ((len0=byte)<0) len0+=256;
      length=((len1*256)+len0);
    
      if (length==0) { //code for RLE compressed block
         fread(&byte, 1, 1, ipsfile);
	 if ((len1=byte)<0) len1+=256;
	 fread(&byte, 1, 1, ipsfile);
	 if ((len0=byte)<0) len0+=256;
	 length=((len1*256)+len0);
	 fread(&byte, 1, 1, ipsfile);
	 for (i=0; i<length; i++) 
	    fwrite(&byte, 1, 1, patchee);
      }
      else { //non compressed
	 for (i=0; i<length; i++) {
	    fread(&byte, 1, 1, ipsfile);
	    fwrite(&byte, 1, 1, patchee);
	 }
      }
   }
   
   fread(&byte, 1, 1, ipsfile);
   if (!feof(ipsfile)) {  //IPS2 stuff     
      if ((len2=byte)<0) len2+=256;
      fread(&byte, 1, 1, ipsfile);
      if ((len1=byte)<0) len1+=256;
      fread(&byte, 1, 1, ipsfile);
      if ((len0=byte)<0) len0+=256;
      length=((len2*256*256)+(len1*256)+len0);
      truncate (argv[2], length);
      printf("File truncated to %d MBit\n", (length/1048576)*8);
   }
   
   printf("Patching complete!\n");
   fclose(patchee);
   fclose(ipsfile);
}
