/* ========================================================================
 *
 * n64ld.x
 *
 * GNU Linker script for building an image that is set up for the N64
 * but still has the data factored into sections.  It is not directly
 * runnable, and it contains the debug info if available.  It will need
 * a 'loader' to perform the final stage of transformation to produce
 * a raw image.
 *
 * Copyright (c) 1999 Ground Zero Development, All rights reserved.
 * Developed by Frank Somers <frank@g0dev.com>
 *
 * $Header$
 *
 * ========================================================================
 */

OUTPUT_FORMAT ("elf32-bigmips", "elf32-bigmips", "elf32-littlemips")
OUTPUT_ARCH (mips)
ENTRY (_start)
SEARCH_DIR (/n64dev/mips-elf/lib);

SECTIONS {
   /* Start address of code is 1K up in uncached, unmapped RAM.  We have
    * to be at least this far up in order to not interfere with the cart
    * boot code which is copying it down from the cart
    */

   . = 0x80000400 ;

   /* The text section carries the app code and its relocation addr is
    * the first byte of the cart domain in cached, unmapped memory
    */

   .text : AT (ADDR (.header) + SIZEOF (.header)) {
      FILL (0)

      __text_start = . ;
      *(.init)
      *(.text)
      *(.ctors)
      *(.dtors)
      *(.rodata)
      *(.fini)
      __text_end  = . ;
   }


   /* Data section has relocation address at start of RAM in cached,
    * unmapped memory, but is loaded just at the end of the text segment,
    * and must be copied to the correct location at startup
    */

   .data : AT (ADDR (.header) + SIZEOF (.header) + SIZEOF (.text)) {
      /* Gather all initialised data together.  The memory layout
       * will place the global initialised data at the lowest addrs.
       * The lit8, lit4, sdata and sbss sections have to be placed
       * together in that order from low to high addrs with the _gp symbol 
       * positioned (aligned) at the start of the sdata section.
       * We then finish off with the standard bss section
       */

      FILL (0xaa)

      __data_start = . ;
         *(.data)
         *(.lit8)
         *(.lit4) ;
      _gp = ALIGN(16) + 0x7ff0 ;
         *(.sdata)
      __data_end = . ;

      __bss_start = . ;
         *(.scommon)
         *(.sbss)
         *(COMMON)
         *(.bss)

      /* XXX Force 8-byte end alignment and update startup code */

      __bss_end = . ;
   }


   /* Now introduce the cart header at the same vma/ lma */

   .header 0xb0000000 : {
      *(.cartheader)
   }

   /* Stabs debugging sections.  These are present in the exe but are
    * never loaded */

   .stab 0 : { *(.stab) }
   .stabstr 0 : { *(.stabstr) }
   .stab.excl 0 : { *(.stab.excl) }
   .stab.exclstr 0 : { *(.stab.exclstr) }
   .stab.index 0 : { *(.stab.index) }
   .stab.indexstr 0 : { *(.stab.indexstr) }
   .comment 0 : { *(.comment) }

   /* DWARF debug sections.
    * Symbols in the DWARF debugging sections are relative to the beginning
    * of the section so we begin them at 0.  */

   /* DWARF 1 */

   .debug          0 : { *(.debug) }
   .line           0 : { *(.line) }

   /* GNU DWARF 1 extensions */

   .debug_srcinfo  0 : { *(.debug_srcinfo) }
   .debug_sfnames  0 : { *(.debug_sfnames) }

   /* DWARF 1.1 and DWARF 2 */

   .debug_aranges  0 : { *(.debug_aranges) }
   .debug_pubnames 0 : { *(.debug_pubnames) }

   /* DWARF 2 */

   .debug_info     0 : { *(.debug_info) }
   .debug_abbrev   0 : { *(.debug_abbrev) }
   .debug_line     0 : { *(.debug_line) }
   .debug_frame    0 : { *(.debug_frame) }
   .debug_str      0 : { *(.debug_str) }
   .debug_loc      0 : { *(.debug_loc) }
   .debug_macinfo  0 : { *(.debug_macinfo) }

   /* SGI/MIPS DWARF 2 extensions */

   .debug_weaknames 0 : { *(.debug_weaknames) }
   .debug_funcnames 0 : { *(.debug_funcnames) }
   .debug_typenames 0 : { *(.debug_typenames) }
   .debug_varnames  0 : { *(.debug_varnames) }

   /* These must appear regardless of  .  */

   .gptab.sdata : { *(.gptab.data) *(.gptab.sdata) }
   .gptab.sbss : { *(.gptab.bss) *(.gptab.sbss) }

   /* Some extra sections... */

   .mdebug 0 : { *(.mdebug) }
   .reginfo (NOLOAD) : { *(.reginfo) }
}
