// ========================================================================
//
// basetype.h
//
// Base type definitions for runtime library
//
// Developed at Ground Zero Development (www.g0dev.com)
//
// ========================================================================

#ifndef  BASETYPE_H
#define  BASETYPE_H

// ------------------------------------------------------------------------
//
// Commonly used machine types
//
//

typedef char BYTE;
typedef BYTE * PBYTE;

typedef unsigned char UBYTE;
typedef UBYTE * PUBYTE;

typedef short SHORT;
typedef SHORT * PSHORT;

typedef unsigned short USHORT;
typedef USHORT * PUSHORT;

typedef long LONG;
typedef LONG * PLONG;

typedef unsigned long ULONG;
typedef ULONG * PULONG;

typedef long long LONGLONG;
typedef LONGLONG * PLONGLONG;

typedef unsigned long long ULONGLONG;
typedef ULONGLONG * PULONGLONG;


// XXX If C++ and compiler supports it, use new boolean type; it may
// generate better code, and will give us stronger type-checking

typedef long BOOL;
#define TRUE 1
#define FALSE 0


// ------------------------------------------------------------------------
//
// Useful language-dependent definitions
//
// XXX Revisit to use gnu language ifdefs

#ifdef   __cplusplus
   #define  EXTERN_C extern "C"
   #define  INLINE   inline
#else
   #define  EXTERN_C /* nothing */
   #define  INLINE   __error_no_inline_keyword__
#endif

// GNU extras of interest

#define  WITH_SECTION_ATTR(sectnamestr) \
   __attribute__ ((section (sectnamestr)))


// ------------------------------------------------------------------------
//
// Macros of use for manipulating addresses - XXX Destined for mipshw.h
//
//

#define  MIPS_K0SEG     0x80000000        // Unmapped, cached
#define  MIPS_K1SEG     0xa0000000        // Unmapped, uncached

#define  MAKE_K0SEG(ulAddr)   ((ulAddr) | MIPS_K1SEG)
#define  MAKE_K1SEG(ulAddr)   ((ulAddr) | MIPS_K1SEG)

#endif


