/*
 * handy dl lib
 *
 */

#include <ultra64.h>
#include "main.h"

extern	u16	_zbuffer[SCREEN_WD*SCREEN_HT];
extern	u16	_rsp_cfb[SCREEN_WD*SCREEN_HT];

#define BG_R 0
#define BG_G 0
#define BG_B 0

Lights1 thelit = gdSPDefLights1( 60, 0, 0,   /* Ambient Light */
                                255,255,255,   /* Infinite, Color */
                                -90, 30, 0    /* Infinite, Direction */
                                );

/*
 * Remember, viewport structures have 2 bits of fraction in them.
 */
static Vp vp = {
	SCREEN_WD*2, SCREEN_HT*2, G_MAXZ/2, 0,	/* scale */
	SCREEN_WD*2, SCREEN_HT*2, G_MAXZ/2, 0,	/* translate */
};

/* initialize the RSP state: */
Gfx rspinit_dl[] = {
    gsSPViewport(&vp),
    gsSPClearGeometryMode(G_SHADE | G_SHADING_SMOOTH | G_CULL_BOTH |
			  G_FOG | G_LIGHTING | G_TEXTURE_GEN |
			  G_TEXTURE_GEN_LINEAR | G_LOD),
    gsSPTexture(0, 0, 0, 0, G_OFF),
    gsSPSetGeometryMode(G_SHADE | G_SHADING_SMOOTH | G_ZBUFFER |
                          G_TEXTURE_GEN | G_TEXTURE_GEN_LINEAR ),
    gsSPEndDisplayList(),
};

/* initialize the RDP state: */
Gfx rdpinit_dl[] = {
    gsDPPipelineMode(G_PM_1PRIMITIVE),
    gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREEN_WD, SCREEN_HT),
    gsDPSetTextureLOD(G_TL_LOD),
    gsDPSetTextureLUT(G_TT_NONE),
    gsDPSetTextureDetail(G_TD_CLAMP),
    gsDPSetTexturePersp(G_TP_PERSP),
    gsDPSetTextureFilter(G_TF_BILERP),
    gsDPSetTextureConvert(G_TC_FILT),
    gsDPSetCombineKey(G_CK_NONE),
    gsDPSetAlphaCompare(G_AC_NONE),
    gsDPSetColorDither(G_CD_ENABLE),
    gsDPSetCombineMode(G_CC_TRILERP, G_CC_MODULATERGB2),
    gsDPPipeSync(),
    gsSPEndDisplayList(),
};

/* clear the color frame buffer: */
Gfx clearcfb_dl[] = {
    gsDPSetCycleType(G_CYC_FILL),
    gsDPSetColorImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD, _rsp_cfb),
    gsDPSetFillColor(GPACK_RGBA5551(BG_R,BG_G,BG_B,1) << 16 | 
		     GPACK_RGBA5551(BG_R,BG_G,BG_B,1)),
    gsDPFillRectangle(0, 0, SCREEN_WD-1, SCREEN_HT-1),
    gsSPEndDisplayList(),
};

/* setup, but don't clean the color frame buffer */
Gfx setupcfb_dl[] = {
    gsDPSetColorImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD, _rsp_cfb),
    gsSPEndDisplayList(),
};

/* clear Z buffer */
Gfx clearZbfr_dl[]= {
    /*
     * clear z, z = max z, dz = 0
     */
    gsDPPipeSync(),
    gsDPSetCycleType(G_CYC_FILL),
    gsDPSetColorImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD,
		_zbuffer),
    gsDPSetFillColor(GPACK_ZDZ(G_MAXFBZ,0) << 16 |
	GPACK_ZDZ(G_MAXFBZ,0)),
    gsDPFillRectangle(0, 0, SCREEN_WD-1, SCREEN_HT-1),
    gsSPEndDisplayList(),
};

Gfx cam_proj[] = {
    gsSPMatrix(&dynamic.projection, G_MTX_PROJECTION|G_MTX_LOAD|G_MTX_NOPUSH),
    gsSPEndDisplayList(),
};

Gfx cam_viewing[] = {
    gsSPMatrix(&dynamic.viewing, G_MTX_MODELVIEW|G_MTX_LOAD|G_MTX_NOPUSH),
    gsSPEndDisplayList(),
};

Gfx lits_dl[] = {
 gsDPPipeSync(),
 gsDPSetCycleType(G_CYC_1CYCLE),

 gsDPSetRenderMode(G_RM_AA_ZB_OPA_SURF, G_RM_AA_ZB_OPA_SURF),

 gsSPClearGeometryMode((G_SHADE | G_SHADING_SMOOTH | G_LIGHTING | \
	G_TEXTURE_GEN | G_TEXTURE_GEN_LINEAR | G_CULL_BOTH | G_FOG)),

 gsSPSetGeometryMode((G_ZBUFFER | G_SHADE | G_SHADING_SMOOTH | \
	G_LIGHTING )),

 gsSPSetLights1(thelit),
 gsSPNumLights(NUMLIGHTS_1),

 gsSPEndDisplayList(),
};
